/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantBeBlockedSourceEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.Ownerable;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;

class DevourerOfMemoryTriggeredAbility
extends TriggeredAbilityImpl {
    DevourerOfMemoryTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(1, 1, Duration.EndOfTurn), false);
        this.addEffect((Effect)new CantBeBlockedSourceEffect(Duration.EndOfTurn));
    }

    private DevourerOfMemoryTriggeredAbility(DevourerOfMemoryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent == null) return false;
        if (zEvent.getFromZone() != Zone.LIBRARY) return false;
        if (zEvent.getToZone() != Zone.GRAVEYARD) return false;
        if (zEvent.getCards() == null) return false;
        if (zEvent.getCards().stream().map(Ownerable::getOwnerId).filter(this.getControllerId()::equals).count() <= 0L) return false;
        return true;
    }

    public DevourerOfMemoryTriggeredAbility copy() {
        return new DevourerOfMemoryTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more cards are put into your graveyard from your library, {this} gets +1/+1 until end of turn and can't be blocked this turn.";
    }
}

