/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;

class DiabolicServitudeReturnCreatureEffect
extends OneShotEffect {
    DiabolicServitudeReturnCreatureEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return target creature card from your graveyard to the battlefield";
    }

    private DiabolicServitudeReturnCreatureEffect(DiabolicServitudeReturnCreatureEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiabolicServitudeReturnCreatureEffect copy() {
        return new DiabolicServitudeReturnCreatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card cardInGraveyard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (cardInGraveyard != null) {
            ReturnFromGraveyardToBattlefieldTargetEffect effect = new ReturnFromGraveyardToBattlefieldTargetEffect();
            effect.setTargetPointer(this.getTargetPointer().copy());
            effect.apply(game, source);
            game.getState().setValue(source.getSourceId().toString() + "returnedCreature", (Object)new MageObjectReference(cardInGraveyard.getId(), game));
            return true;
        }
        return false;
    }
}

