/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class DichotomancyEffect
extends OneShotEffect {
    private static final FilterNonlandPermanent filter = new FilterNonlandPermanent();

    DichotomancyEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "For each tapped nonland permanent target opponent controls, search that player's library for a card with the same name as that permanent. Put those cards onto the battlefield under your control, then that player shuffles.";
    }

    private DichotomancyEffect(DichotomancyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && opponent != null) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, opponent.getId(), game)) {
                String name = permanent.getName();
                FilterCard filterCard = new FilterCard("card named \"" + name + '\"');
                filterCard.add((Predicate)new NamePredicate(name));
                TargetCardInLibrary target = new TargetCardInLibrary(0, 1, filterCard);
                if (!controller.searchLibrary(target, source, game, opponent.getId())) continue;
                controller.moveCards(opponent.getLibrary().getCard(target.getFirstTarget(), game), Zone.BATTLEFIELD, source, game);
            }
            opponent.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public DichotomancyEffect copy() {
        return new DichotomancyEffect(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
    }
}

