/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DictateOfTheTwinGodsEffect
extends ReplacementEffectImpl {
    DictateOfTheTwinGodsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source would deal damage to a permanent or player, it deals double that damage to that permanent or player instead";
    }

    private DictateOfTheTwinGodsEffect(DictateOfTheTwinGodsEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DictateOfTheTwinGodsEffect copy() {
        return new DictateOfTheTwinGodsEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        if (damageEvent.getType() == GameEvent.EventType.DAMAGE_PLAYER) {
            Player targetPlayer = game.getPlayer(event.getTargetId());
            if (targetPlayer != null) {
                targetPlayer.damage(CardUtil.overflowInc((int)damageEvent.getAmount(), (int)damageEvent.getAmount()), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
                return true;
            }
        } else {
            Permanent targetPermanent = game.getPermanent(event.getTargetId());
            if (targetPermanent != null) {
                targetPermanent.damage(CardUtil.overflowInc((int)damageEvent.getAmount(), (int)damageEvent.getAmount()), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
                return true;
            }
        }
        return false;
    }
}

