/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.cards.Card;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInOpponentsGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DiluvianPrimordialEffect
extends OneShotEffect {
    DiluvianPrimordialEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "for each opponent, you may cast up to one target instant or sorcery card from that player's graveyard without paying its mana cost. If a spell cast this way would be put into a graveyard, exile it instead";
    }

    private DiluvianPrimordialEffect(DiluvianPrimordialEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiluvianPrimordialEffect copy() {
        return new DiluvianPrimordialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Target target : source.getTargets()) {
                Card targetCard;
                if (!(target instanceof TargetCardInOpponentsGraveyard) || (targetCard = game.getCard(target.getFirstTarget())) == null) continue;
                new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST, true).setTargetPointer((TargetPointer)new FixedTarget(targetCard, game)).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

