/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.d.DimensionalBreachDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DimensionalBreachExileEffect
extends OneShotEffect {
    DimensionalBreachExileEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile all permanents. For as long as any of those cards remain exiled, at the beginning of each player's upkeep, that player returns one of the exiled cards they own to the battlefield.";
    }

    private DimensionalBreachExileEffect(DimensionalBreachExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public DimensionalBreachExileEffect copy() {
        return new DimensionalBreachExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getBattlefield().getActivePermanents(source.getControllerId(), game).stream().forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        Set<MageObjectReference> morSet = cards.getCards(game).stream().filter(c -> game.getState().getZone(c.getId()) == Zone.EXILED).map(c -> new MageObjectReference((MageObject)c, game)).collect(Collectors.toSet());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new DimensionalBreachDelayedTriggeredAbility(morSet), source);
        return true;
    }
}

