/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DimensionalInfiltratorEffect
extends OneShotEffect {
    DimensionalInfiltratorEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "exile the top card of target opponent's library. If it's a land card, you may return {this} to its owner's hand";
    }

    private DimensionalInfiltratorEffect(DimensionalInfiltratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public DimensionalInfiltratorEffect copy() {
        return new DimensionalInfiltratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (player == null || opponent == null) {
            return false;
        }
        Card card = opponent.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (!card.isLand(game)) {
            return true;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        return permanent != null && player.chooseUse(this.outcome, "Return " + permanent.getName() + " to its owner's hand?", source, game) && player.moveCards((Card)permanent, Zone.HAND, source, game);
    }
}

