/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class DimirCharmEffect
extends OneShotEffect {
    DimirCharmEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top three cards of target player's library, then put one back and the rest into that player's graveyard";
    }

    private DimirCharmEffect(DimirCharmEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && player != null) {
            CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
            if (!cards.isEmpty()) {
                Card card;
                TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("Card to put back on top of library"));
                if (controller.chooseTarget(Outcome.Benefit, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
                    cards.remove(card);
                }
                controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            }
            return true;
        }
        return false;
    }

    public DimirCharmEffect copy() {
        return new DimirCharmEffect(this);
    }
}

