/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DinosaurHunterAbility
extends TriggeredAbilityImpl {
    DinosaurHunterAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect());
    }

    private DinosaurHunterAbility(DinosaurHunterAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DinosaurHunterAbility copy() {
        return new DinosaurHunterAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getSourceId().equals(this.getSourceId())) {
            return false;
        }
        Permanent targetPermanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (targetPermanent == null || !targetPermanent.hasSubtype(SubType.DINOSAUR, game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
        return true;
    }

    public String getRule() {
        return "Whenever {this} deals damage to a Dinosaur, destroy that creature.";
    }
}

