/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.replacement.ThatSpellGraveyardExileReplacementEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DireFleetDaredevilEffect
extends OneShotEffect {
    DireFleetDaredevilEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target instant or sorcery card from an opponent's graveyard. You may cast it this turn, and mana of any type can be spent to cast that spell. If that spell would be put into a graveyard, exile it instead.";
    }

    private DireFleetDaredevilEffect(DireFleetDaredevilEffect effect) {
        super((OneShotEffect)effect);
    }

    public DireFleetDaredevilEffect copy() {
        return new DireFleetDaredevilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Card targetCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetCard == null) {
            return false;
        }
        if (controller.moveCards(targetCard, Zone.EXILED, source, game) && (card = game.getCard(targetCard.getId())) != null) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)true);
            ThatSpellGraveyardExileReplacementEffect effect = new ThatSpellGraveyardExileReplacementEffect(false);
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

