/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class DiregrafCaptainTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Zombie");

    public DiregrafCaptainTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(1), false);
        this.addTarget((Target)new TargetOpponent());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private DiregrafCaptainTriggeredAbility(DiregrafCaptainTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (!event.getTargetId().equals(this.getSourceId()) && (zEvent = (ZoneChangeEvent)event).isDiesEvent()) {
            Permanent p = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD);
            return p != null && p.isControlledBy(this.controllerId) && filter.match((Object)p, game);
        }
        return false;
    }

    public DiregrafCaptainTriggeredAbility copy() {
        return new DiregrafCaptainTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever another Zombie you control dies, target opponent loses 1 life.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }

    static {
        filter.add((Predicate)SubType.ZOMBIE.getPredicate());
    }
}

