/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class DiscoverTheImpossibleEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    DiscoverTheImpossibleEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "look at the top five cards of your library. Exile one of them face down and put the rest on the bottom of your library in a random order. You may cast the exiled card without paying its mana cost if it's an instant spell with mana value 2 or less. If you don't, put that card into your hand";
    }

    private DiscoverTheImpossibleEffect(DiscoverTheImpossibleEffect effect) {
        super((OneShotEffect)effect);
    }

    public DiscoverTheImpossibleEffect copy() {
        return new DiscoverTheImpossibleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            player.putCardsOnBottomOfLibrary(card, game, source);
            return true;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        card.setFaceDown(true, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl(card), (FilterCard)filter) || player.moveCards(card, Zone.HAND, source, game);
    }

    static {
        filter.add((Predicate)CardType.INSTANT.getPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

