/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DismalFailureEffect
extends OneShotEffect {
    DismalFailureEffect() {
        super(Outcome.Neutral);
        this.staticText = "Counter target spell. Its controller discards a card";
    }

    private DismalFailureEffect(DismalFailureEffect effect) {
        super((OneShotEffect)effect);
    }

    public DismalFailureEffect copy() {
        return new DismalFailureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = source.getFirstTarget();
        Player controller = null;
        boolean countered = false;
        if (targetId != null) {
            controller = game.getPlayer(game.getControllerId(targetId));
        }
        if (targetId != null && game.getStack().counter(targetId, source, game)) {
            countered = true;
        }
        if (controller != null) {
            controller.discard(1, false, false, source, game);
        }
        return countered;
    }
}

