/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class DisplacementWaveEffect
extends OneShotEffect {
    DisplacementWaveEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return all nonland permanents with mana value X or less to their owners' hands";
    }

    private DisplacementWaveEffect(DisplacementWaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public DisplacementWaveEffect copy() {
        return new DisplacementWaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (permanent.isLand(game) || permanent.getManaValue() > (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)) continue;
            cards.add((Card)permanent);
        }
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }
}

