/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class DisplayOfDominanceEffect
extends ContinuousRuleModifyingEffectImpl {
    DisplayOfDominanceEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "permanents you control can't be the targets of blue or black spells your opponents control this turn";
    }

    private DisplayOfDominanceEffect(DisplayOfDominanceEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public DisplayOfDominanceEffect copy() {
        return new DisplayOfDominanceEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability ability, Game game) {
        MageObject mageObject = game.getObject(event.getSourceId());
        if (game.getPlayer(ability.getControllerId()).hasOpponent(event.getPlayerId(), game) && mageObject instanceof Spell && (mageObject.getColor(game).isBlack() || mageObject.getColor(game).isBlue())) {
            Permanent permanent = game.getPermanent(event.getTargetId());
            return permanent != null && permanent.isControlledBy(ability.getControllerId());
        }
        return false;
    }
}

