/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Iterator;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class DisruptingShoalCounterTargetEffect
extends OneShotEffect {
    DisruptingShoalCounterTargetEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell if its mana value is X";
    }

    private DisruptingShoalCounterTargetEffect(DisruptingShoalCounterTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public DisruptingShoalCounterTargetEffect copy() {
        return new DisruptingShoalCounterTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null && this.isManaValueEqual(source, spell.getManaValue(), game)) {
            return game.getStack().counter(source.getFirstTarget(), source, game);
        }
        return false;
    }

    private boolean isManaValueEqual(Ability sourceAbility, int amount, Game game) {
        for (Cost cost : sourceAbility.getCosts()) {
            if (!cost.isPaid() || !(cost instanceof ExileFromHandCost)) continue;
            Iterator iterator = ((ExileFromHandCost)cost).getCards().iterator();
            if (iterator.hasNext()) {
                Card card = (Card)iterator.next();
                return card.getManaValue() == amount;
            }
            return false;
        }
        return (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)sourceAbility, (String)"X", (Object)0) == amount;
    }
}

