/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class DisruptorFluteCostIncreaseEffect
extends CostModificationEffectImpl {
    DisruptorFluteCostIncreaseEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, CostModificationType.INCREASE_COST);
        this.staticText = "Spells with the chosen name cost {3} more to cast";
    }

    private DisruptorFluteCostIncreaseEffect(DisruptorFluteCostIncreaseEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public DisruptorFluteCostIncreaseEffect copy() {
        return new DisruptorFluteCostIncreaseEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)3);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card card;
        if (abilityToModify instanceof SpellAbility && (card = game.getCard(abilityToModify.getSourceId())) != null) {
            String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
            return CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game);
        }
        return false;
    }
}

