/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class DivinePresenceEffect
extends ReplacementEffectImpl {
    DivinePresenceEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If a source would deal 4 or more damage to a permanent or player, that source deals 3 damage to that permanent or player instead.";
    }

    private DivinePresenceEffect(DivinePresenceEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DivinePresenceEffect copy() {
        return new DivinePresenceEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getAmount() > 3;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(3);
        return false;
    }
}

