/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Iterator;
import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.AngelVigilanceToken;
import mage.game.permanent.token.Token;

class DivineVisitationEffect
extends ReplacementEffectImpl {
    DivineVisitationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, false);
        this.staticText = "If one or more creature tokens would be created under your control, that many 4/4 white Angel creature tokens with flying and vigilance are created instead.";
    }

    private DivineVisitationEffect(DivineVisitationEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event instanceof CreateTokenEvent && event.getPlayerId().equals(source.getControllerId())) {
            CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
            for (Token token : tokenEvent.getTokens().keySet()) {
                if (!token.isCreature(game)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event instanceof CreateTokenEvent) {
            int amount = 0;
            CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
            Iterator it = tokenEvent.getTokens().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!((Token)entry.getKey()).isCreature(game)) continue;
                amount += ((Integer)entry.getValue()).intValue();
                it.remove();
            }
            if (amount > 0) {
                tokenEvent.getTokens().put(new AngelVigilanceToken(), amount);
            }
        }
        return false;
    }

    public DivineVisitationEffect copy() {
        return new DivineVisitationEffect(this);
    }
}

