/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class DivinerOfMistEffect
extends OneShotEffect {
    public DivinerOfMistEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "mill four cards. You may cast an instant or sorcery spell from your graveyard with mana value 4 or less without paying its mana cost";
    }

    protected DivinerOfMistEffect(DivinerOfMistEffect effect) {
        super((OneShotEffect)effect);
    }

    public DivinerOfMistEffect copy() {
        return new DivinerOfMistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Cards milledCards = controller.millCards(4, source, game);
        boolean hasTarget = controller.getGraveyard().getCards(game).stream().anyMatch(card -> card.getManaValue() <= 4 && card.isInstantOrSorcery(game));
        if (!hasTarget) {
            return true;
        }
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 4));
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)filter);
        target.withNotTarget(true);
        controller.chooseTarget(Outcome.PlayForFree, (Target)target, source, game);
        Card card2 = game.getCard(target.getFirstTarget());
        if (card2 != null) {
            card2 = card2.getMainCard();
            game.getState().setValue("DivinerOfMist", (Object)new MageObjectReference((MageObject)card2, game));
            return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card2, (FilterCard)filter);
        }
        return true;
    }
}

