/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DivinersLockboxEffect
extends OneShotEffect {
    private static final Effect sacEffect = new SacrificeSourceEffect();

    DivinersLockboxEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a card name, then reveal the top card of your library. If that card has the chosen name, sacrifice {this} and draw three cards.";
    }

    private DivinersLockboxEffect(DivinersLockboxEffect effect) {
        super((OneShotEffect)effect);
    }

    public DivinersLockboxEffect copy() {
        return new DivinersLockboxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.ALL.getChoice(player, game, source, false);
        Card card = player.getLibrary().getFromTop(game);
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) {
            sacEffect.apply(game, source);
            player.drawCards(3, source, game);
        }
        return true;
    }
}

