/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DjeruWithEyesOpenPreventEffect
extends PreventionEffectImpl {
    DjeruWithEyesOpenPreventEffect() {
        super(Duration.WhileOnBattlefield, 1, false, false);
        this.staticText = "If a source would deal damage to a planeswalker you control, prevent 1 of that damage";
    }

    private DjeruWithEyesOpenPreventEffect(DjeruWithEyesOpenPreventEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isPlaneswalker(game) && permanent.isControlledBy(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public DjeruWithEyesOpenPreventEffect copy() {
        return new DjeruWithEyesOpenPreventEffect(this);
    }
}

