/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DjinnOfWishesEffect
extends OneShotEffect {
    DjinnOfWishesEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Reveal the top card of your library. You may play that card without paying its mana cost. If you don't, exile it";
    }

    private DjinnOfWishesEffect(DjinnOfWishesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null && controller.getLibrary().hasCards()) {
            Card card = controller.getLibrary().getFromTop(game);
            CardsImpl cards = new CardsImpl(card);
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            if (!controller.chooseUse(Outcome.PlayForFree, "Play " + card.getName() + " without paying its mana cost?", source, game) || !controller.playCard(card, game, true, new ApprovingObject(source, game))) {
                controller.moveCards(card, Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }

    public DjinnOfWishesEffect copy() {
        return new DjinnOfWishesEffect(this);
    }
}

