/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class DoOrDieEffect
extends OneShotEffect {
    DoOrDieEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Separate all creatures target player controls into two piles. Destroy all creatures in the pile of that player's choice. They can't be regenerated";
    }

    private DoOrDieEffect(DoOrDieEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoOrDieEffect copy() {
        return new DoOrDieEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (player == null || targetPlayer == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures to put in the first pile");
        filter.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
        TargetPermanent creatures = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)filter, true);
        ArrayList<Permanent> pile1 = new ArrayList<Permanent>();
        if (player.choose(Outcome.Neutral, (Target)creatures, source, game)) {
            List targets = creatures.getTargets();
            for (UUID targetId : targets) {
                Permanent p = game.getPermanent(targetId);
                if (p == null) continue;
                pile1.add(p);
            }
        }
        ArrayList<Permanent> pile2 = new ArrayList<Permanent>();
        for (Permanent p : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, targetPlayer.getId(), game)) {
            if (pile1.contains(p)) continue;
            pile2.add(p);
        }
        boolean choice = targetPlayer.choosePile(Outcome.DestroyPermanent, "Choose a pile to destroy.", pile1, pile2, game);
        if (choice) {
            this.destroyPermanents(pile1, game, source);
        } else {
            this.destroyPermanents(pile2, game, source);
        }
        return true;
    }

    private void destroyPermanents(List<Permanent> pile, Game game, Ability source) {
        for (Permanent permanent : pile) {
            if (permanent == null) continue;
            permanent.destroy(source, game, true);
        }
    }
}

