/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.PlotAbility;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DocAurlockGrizzledGeniusEffect
extends CostModificationEffectImpl {
    public DocAurlockGrizzledGeniusEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Plotting cards from your hand costs {2} less";
    }

    private DocAurlockGrizzledGeniusEffect(DocAurlockGrizzledGeniusEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public DocAurlockGrizzledGeniusEffect copy() {
        return new DocAurlockGrizzledGeniusEffect(this);
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.isControlledBy(source.getControllerId()) && abilityToModify instanceof PlotAbility;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        if (!Zone.HAND.equals((Object)game.getState().getZone(abilityToModify.getSourceId()))) {
            return false;
        }
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller != null) {
            Mana mana = abilityToModify.getManaCostsToPay().getMana();
            int reduce = mana.getGeneric();
            if (reduce > 2) {
                reduce = 2;
            }
            if (reduce > 0) {
                CardUtil.reduceCost((Ability)abilityToModify, (int)reduce);
            }
            return true;
        }
        return false;
    }
}

