/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class DogmeatEverLoyalEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Aura or Equipment card");

    DogmeatEverLoyalEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then return an Aura or Equipment card from your graveyard to your hand";
    }

    private DogmeatEverLoyalEffect(DogmeatEverLoyalEffect effect) {
        super((OneShotEffect)effect);
    }

    public DogmeatEverLoyalEffect copy() {
        return new DogmeatEverLoyalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count(filter, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.AURA.getPredicate(), (Predicate)SubType.EQUIPMENT.getPredicate()));
    }
}

