/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class DoomfallEffect
extends OneShotEffect {
    DoomfallEffect() {
        super(Outcome.Exile);
        this.staticText = "target opponent exiles a creature they control";
    }

    private DoomfallEffect(DoomfallEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoomfallEffect copy() {
        return new DoomfallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            if (targetPlayer.choose(this.outcome, (Target)target, source, game)) {
                targetPlayer.moveCards((Card)game.getPermanent(target.getFirstTarget()), Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }
}

