/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class DoomgapeEffect
extends OneShotEffect {
    DoomgapeEffect() {
        super(Outcome.GainLife);
        this.staticText = "sacrifice a creature. You gain life equal to that creature's toughness";
    }

    private DoomgapeEffect(DoomgapeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoomgapeEffect copy() {
        return new DoomgapeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature;
        TargetSacrifice target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.choose(Outcome.Sacrifice, (Target)(target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE)), source, game) && (creature = game.getPermanent(target.getFirstTarget())) != null && creature.sacrifice(source, game)) {
            controller.gainLife(creature.getToughness().getValue(), game, source);
            return true;
        }
        return false;
    }
}

