/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DoomsdayExcruciatorEffect
extends OneShotEffect {
    DoomsdayExcruciatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player exiles all but the bottom six cards of their library face down";
    }

    private DoomsdayExcruciatorEffect(DoomsdayExcruciatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoomsdayExcruciatorEffect copy() {
        return new DoomsdayExcruciatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            int amount;
            Player player = game.getPlayer(playerId);
            if (player == null || (amount = player.getLibrary().size() - 6) <= 0) continue;
            cards.addAllCards((Collection)player.getLibrary().getTopCards(game, amount));
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.getCards(game).stream().forEach(card -> card.setFaceDown(true, game));
        return true;
    }
}

