/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.d.DoublingChantTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class DoublingChantEffect
extends OneShotEffect {
    DoublingChantEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "For each creature you control, you may search your library for a creature card with the same name as that creature. Put those cards onto the battlefield, then shuffle";
    }

    private DoublingChantEffect(DoublingChantEffect effect) {
        super((OneShotEffect)effect);
    }

    public DoublingChantEffect copy() {
        return new DoublingChantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List<String> names = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().filter(Objects::nonNull).map(MageObject::getName).collect(Collectors.toList());
        DoublingChantTarget targetCardInLibrary = new DoublingChantTarget(names);
        player.searchLibrary((TargetCardInLibrary)targetCardInLibrary, source, game);
        CardsImpl cards = new CardsImpl((Collection)targetCardInLibrary.getTargets());
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

