/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DiesAttachedTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.effects.common.continuous.AddCardSubtypeAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class DraconicDestiny
extends CardImpl {
    public DraconicDestiny(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}{R}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(1, 1, Duration.WhileOnBattlefield));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)FlyingAbility.getInstance(), AttachmentType.AURA).setText("and has flying"));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)HasteAbility.getInstance(), AttachmentType.AURA).setText(", haste"));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)new SimpleActivatedAbility((Effect)new BoostSourceEffect(1, 0, Duration.EndOfTurn), (Cost)new GenericManaCost(1)), AttachmentType.AURA).setText(", and \"{1}: This creature gets +1/+0 until end of turn.\""));
        ability.addEffect((Effect)new AddCardSubtypeAttachedEffect(SubType.DRAGON, AttachmentType.AURA).setText("It's a Dragon in addition to its other types"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new DiesAttachedTriggeredAbility((Effect)new ReturnToHandSourceEffect(false, true), "enchanted creature"));
    }

    private DraconicDestiny(DraconicDestiny card) {
        super((CardImpl)card);
    }

    public DraconicDestiny copy() {
        return new DraconicDestiny(this);
    }
}

