/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DragonTempestDamageEffect
extends OneShotEffect {
    private static final FilterControlledPermanent dragonFilter = new FilterControlledPermanent();

    public DragonTempestDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals X damage to any target, where X is the number of Dragons you control";
    }

    private DragonTempestDamageEffect(DragonTempestDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public DragonTempestDamageEffect copy() {
        return new DragonTempestDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent damageSource = (Permanent)this.getValue("permanentEnteringBattlefield");
            int amount = game.getBattlefield().countAll((FilterPermanent)dragonFilter, controller.getId(), game);
            if (amount > 0) {
                Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (targetCreature != null) {
                    targetCreature.damage(amount, damageSource.getId(), source, game, false, true);
                } else {
                    Player player = game.getPlayer(source.getTargets().getFirstTarget());
                    if (player != null) {
                        player.damage(amount, damageSource.getId(), source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }

    static {
        dragonFilter.add((Predicate)SubType.DRAGON.getPredicate());
    }
}

