/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DragonlordKolaghanTriggeredAbility
extends TriggeredAbilityImpl {
    public DragonlordKolaghanTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
        this.setTriggerPhrase("Whenever an opponent casts a creature or planeswalker spell with the same name as a card in their graveyard, ");
    }

    private DragonlordKolaghanTriggeredAbility(DragonlordKolaghanTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DragonlordKolaghanTriggeredAbility copy() {
        return new DragonlordKolaghanTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player opponent;
        Spell spell;
        Player controller = game.getPlayer(this.getControllerId());
        if (controller != null && controller.hasOpponent(event.getPlayerId(), game) && (spell = game.getStack().getSpell(event.getSourceId())) != null && !spell.isFaceDown(game) && (spell.isCreature(game) || spell.isPlaneswalker(game)) && (opponent = game.getPlayer(event.getPlayerId())) != null) {
            boolean sameName = false;
            for (Card graveCard : opponent.getGraveyard().getCards(game)) {
                if (!CardUtil.haveSameNames((MageObject)graveCard, (MageObject)spell)) continue;
                sameName = true;
                break;
            }
            if (sameName) {
                ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
                return true;
            }
        }
        return false;
    }
}

