/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.d.DragonsFireCost;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DragonsFireEffect
extends OneShotEffect {
    DragonsFireEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to target creature or planeswalker. If you revealed a Dragon card or chose a Dragon as you cast this spell, {this} deals damage equal to the power of that card or creature instead";
    }

    private DragonsFireEffect(DragonsFireEffect effect) {
        super((OneShotEffect)effect);
    }

    public DragonsFireEffect copy() {
        return new DragonsFireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetedPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetedPermanent == null) {
            return false;
        }
        Enum dragonZone = null;
        UUID selectedCardId = null;
        int damage = 3;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof DragonsFireCost)) continue;
            DragonsFireCost dragonsFireCost = (DragonsFireCost)cost;
            dragonZone = dragonsFireCost.getDragonZone();
            selectedCardId = dragonsFireCost.getSelectedCardId();
            break;
        }
        if (dragonZone != null) {
            switch (1.$SwitchMap$mage$cards$d$DragonsFireCost$DragonZone[dragonZone.ordinal()]) {
                case 1: {
                    Card card = game.getCard(selectedCardId);
                    if (card == null) break;
                    damage = card.getPower().getValue();
                    break;
                }
                case 2: {
                    Permanent dragon = game.getPermanentOrLKIBattlefield(selectedCardId);
                    if (dragon == null) break;
                    damage = dragon.getPower().getValue();
                }
            }
        }
        targetedPermanent.damage(damage, source.getSourceId(), source, game);
        return true;
    }
}

