/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DralnusPetEffect
extends OneShotEffect {
    DralnusPetEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "and with X +1/+1 counters on it, where X is the discarded card's mana value";
    }

    private DralnusPetEffect(DralnusPetEffect effect) {
        super((OneShotEffect)effect);
    }

    public DralnusPetEffect copy() {
        return new DralnusPetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null && source.getAbilityType() == AbilityType.STATIC) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        if (controller != null && permanent != null) {
            SpellAbility spellAbility = (SpellAbility)this.getValue("sourceCastSpellAbility");
            if (spellAbility != null && spellAbility.getSourceId().equals(source.getSourceId()) && permanent.getZoneChangeCounter(game) == spellAbility.getStackMomentSourceZCC()) {
                int cmc = 0;
                for (Cost cost : spellAbility.getCosts()) {
                    if (cost instanceof DiscardCardCost && !((DiscardCardCost)cost).getCards().isEmpty()) {
                        cmc = ((Card)((DiscardCardCost)cost).getCards().get(0)).getManaValue();
                    }
                    if (cmc <= 0) continue;
                    return new AddCountersSourceEffect(CounterType.P1P1.createInstance(cmc), true).apply(game, source);
                }
            }
            return true;
        }
        return false;
    }
}

