/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DramaticAccusationEffect
extends OneShotEffect {
    DramaticAccusationEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle enchanted creature into its owner's library";
    }

    private DramaticAccusationEffect(DramaticAccusationEffect effect) {
        super((OneShotEffect)effect);
    }

    public DramaticAccusationEffect copy() {
        return new DramaticAccusationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
        if (permanent == null) {
            return false;
        }
        Player owner = game.getPlayer(permanent.getOwnerId());
        return owner != null && owner.shuffleCardsToLibrary((Card)permanent, game, source);
    }
}

