/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DrasticRevelationEffect
extends OneShotEffect {
    DrasticRevelationEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Discard your hand. Draw seven cards, then discard three cards at random";
    }

    private DrasticRevelationEffect(DrasticRevelationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        if (you == null) {
            return false;
        }
        you.discard(you.getHand(), false, source, game);
        you.drawCards(7, source, game);
        you.discard(3, true, false, source, game);
        return false;
    }

    public DrasticRevelationEffect copy() {
        return new DrasticRevelationEffect(this);
    }
}

