/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;

class DraugrNecromancerCastFromExileEffect
extends AsThoughEffectImpl {
    DraugrNecromancerCastFromExileEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may cast spells from among cards in exile your opponents own with ice counters on them";
    }

    private DraugrNecromancerCastFromExileEffect(DraugrNecromancerCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public DraugrNecromancerCastFromExileEffect copy() {
        return new DraugrNecromancerCastFromExileEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card card = game.getCard(sourceId);
        if (card == null) {
            return false;
        }
        if (!source.isControlledBy(affectedControllerId) || game.getState().getZone(card.getMainCard().getId()) != Zone.EXILED) {
            return false;
        }
        return !card.isLand(game) && game.getOpponents(card.getOwnerId()).contains(source.getControllerId()) && card.getMainCard().getCounters(game).getCount(CounterType.ICE) > 0;
    }
}

