/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class DreadhoundTriggeredAbility
extends TriggeredAbilityImpl {
    public DreadhoundTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeOpponentsEffect(1));
        this.setTriggerPhrase("Whenever a creature dies or a creature card is put into a graveyard from a library, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private DreadhoundTriggeredAbility(DreadhoundTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DreadhoundTriggeredAbility copy() {
        return new DreadhoundTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.GRAVEYARD) {
            if (zEvent.getFromZone() == Zone.BATTLEFIELD) {
                Permanent permanent = zEvent.getTarget();
                return permanent != null && permanent.isCreature(game);
            }
            if (zEvent.getFromZone() == Zone.LIBRARY) {
                Card card = game.getCard(zEvent.getTargetId());
                return card != null && card.isCreature(game);
            }
        }
        return false;
    }
}

