/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.CumulativeUpkeepAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class DreamsOfTheDeadEffect
extends OneShotEffect {
    DreamsOfTheDeadEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return target white or black creature card from your graveyard to the battlefield. That creature gains \"Cumulative upkeep {2}.\"";
    }

    private DreamsOfTheDeadEffect(DreamsOfTheDeadEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreamsOfTheDeadEffect copy() {
        return new DreamsOfTheDeadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && card != null) {
            Permanent creature;
            if (controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)new CumulativeUpkeepAbility((Cost)new ManaCostsImpl("{2}")), Duration.Custom);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

