/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.BeastToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.target.Target;

class DruidOfHornsTriggeredAbility
extends TriggeredAbilityImpl {
    public DruidOfHornsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new BeastToken()), false);
        this.setTriggerPhrase("Whenever you cast an Aura spell that targets {this}, ");
    }

    private DruidOfHornsTriggeredAbility(DruidOfHornsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DruidOfHornsTriggeredAbility copy() {
        return new DruidOfHornsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        return event.getPlayerId().equals(this.getControllerId()) && this.checkSpell(spell = game.getStack().getSpell(event.getTargetId()), game);
    }

    private boolean checkSpell(Spell spell, Game game) {
        if (spell != null && spell.hasSubtype(SubType.AURA, game)) {
            SpellAbility sa = spell.getSpellAbility();
            for (UUID modeId : sa.getModes().getSelectedModes()) {
                Mode mode = sa.getModes().get((Object)modeId);
                for (Target target : mode.getTargets()) {
                    if (target.isNotTarget() || !target.getTargets().contains(this.getSourceId())) continue;
                    return true;
                }
                for (Effect effect : mode.getEffects()) {
                    for (UUID targetId : effect.getTargetPointer().getTargets(game, (Ability)sa)) {
                        if (!targetId.equals(this.getSourceId())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

