/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactOrEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class DruidOfPurificationEffect
extends OneShotEffect {
    DruidOfPurificationEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player may choose an artifact or enchantment you don't control. Destroy each permanent chosen this way";
    }

    private DruidOfPurificationEffect(DruidOfPurificationEffect effect) {
        super((OneShotEffect)effect);
    }

    public DruidOfPurificationEffect copy() {
        return new DruidOfPurificationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterArtifactOrEnchantmentPermanent filter = new FilterArtifactOrEnchantmentPermanent("artifact or enchantment not controlled by " + controller.getName());
        filter.add(Predicates.not((Predicate)new ControllerIdPredicate(controller.getId())));
        if (game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) < 1) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)filter);
        target.withNotTarget(true);
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            target.clearChosen();
            player.choose(Outcome.DestroyPermanent, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) {
                game.informPlayers(player.getLogName() + " has not chosen a permanent");
                continue;
            }
            game.informPlayers(player.getLogName() + " has chosen " + permanent.getLogName());
            permanents.add(permanent);
        }
        for (Permanent permanent : permanents) {
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

