/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.AnotherEnchantedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class DueDiligence
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creature you control other than enchanted creature");

    public DueDiligence(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        EntersBattlefieldTriggeredAbility ability = new EntersBattlefieldTriggeredAbility((Effect)new BoostTargetEffect(2, 2).setText("target creature you control other than enchanted creature gets +2/+2"));
        ability.addEffect((Effect)new GainAbilityTargetEffect((Ability)VigilanceAbility.getInstance()).setText("and gains vigilance until end of turn"));
        ability.addTarget((Target)new TargetPermanent(filter));
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(2, 2));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)VigilanceAbility.getInstance(), AttachmentType.AURA).setText("and has vigilance"));
        this.addAbility((Ability)ability);
    }

    private DueDiligence(DueDiligence card) {
        super((CardImpl)card);
    }

    public DueDiligence copy() {
        return new DueDiligence(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherEnchantedPredicate.instance);
    }
}

