/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DuneChanterEffect
extends OneShotEffect {
    DuneChanterEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill two cards. You gain 1 life for each land card milled this way.";
    }

    private DuneChanterEffect(DuneChanterEffect effect) {
        super((OneShotEffect)effect);
    }

    public DuneChanterEffect copy() {
        return new DuneChanterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int lifeToGain = player.millCards(2, source, game).getCards(game).stream().filter(c -> c.isLand(game)).mapToInt(c -> game.getState().getZone(c.getId()) == Zone.GRAVEYARD ? 1 : 0).sum();
        if (lifeToGain > 0) {
            new GainLifeEffect(lifeToGain).apply(game, source);
        }
        return true;
    }
}

