/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DuplicantContinuousEffect
extends ContinuousEffectImpl {
    DuplicantContinuousEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "As long as a card exiled with {this} is a creature card, {this} has the power, toughness, and creature types of the last creature card exiled with it. It's still a Shapeshifter.";
    }

    private DuplicantContinuousEffect(DuplicantContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public DuplicantContinuousEffect copy() {
        return new DuplicantContinuousEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        if (permanent.getImprinted().isEmpty()) {
            return false;
        }
        List imprinted = permanent.getImprinted();
        if (imprinted == null || imprinted.isEmpty()) {
            return false;
        }
        Card card = game.getCard((UUID)imprinted.get(imprinted.size() - 1));
        if (card == null || !card.isCreature(game)) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.copySubTypesFrom(game, (MageObject)card, SubTypeSet.CreatureType);
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(card.getPower().getValue());
                permanent.getToughness().setModifiedBaseValue(card.getToughness().getValue());
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
    }
}

