/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DuplicityEffect
extends OneShotEffect {
    DuplicityEffect() {
        super(Outcome.Exile);
        this.staticText = "exile the top five cards of your library face down";
    }

    private DuplicityEffect(DuplicityEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            if (controller.getLibrary().hasCards()) {
                UUID exileId = source.getSourceId();
                Set cardsToExile = controller.getLibrary().getTopCards(game, 5);
                for (Card card : cardsToExile) {
                    controller.moveCardsToExile(card, source, game, true, exileId, sourceObject.getName());
                    card.setFaceDown(true, game);
                }
            }
            return true;
        }
        return false;
    }

    public DuplicityEffect copy() {
        return new DuplicityEffect(this);
    }
}

