/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DuplicityExileHandEffect
extends OneShotEffect {
    DuplicityExileHandEffect() {
        super(Outcome.Exile);
        this.staticText = "you may exile all cards from your hand face down. If you do, put all other cards you own exiled with {this} into your hand";
    }

    private DuplicityExileHandEffect(DuplicityExileHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            UUID exileId = source.getSourceId();
            Set cardsInExile = game.getExile().getExileZone(exileId).getCards(game);
            if (controller.getHand().isEmpty()) {
                controller.moveCards(cardsInExile, Zone.HAND, source, game);
            } else {
                Set cardsFromHandToExile = controller.getHand().getCards(game);
                for (Card card : cardsFromHandToExile) {
                    controller.moveCardsToExile(card, source, game, true, exileId, sourceObject.getName());
                    card.setFaceDown(true, game);
                }
                HashSet<Card> cardsToReturnToHandFromExile = new HashSet<Card>();
                for (Card card : cardsInExile) {
                    if (cardsFromHandToExile.contains(card)) continue;
                    cardsToReturnToHandFromExile.add(card);
                }
                controller.moveCards(cardsToReturnToHandFromExile, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }

    public DuplicityExileHandEffect copy() {
        return new DuplicityExileHandEffect(this);
    }
}

