/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DuskmantleSeerEffect
extends OneShotEffect {
    DuskmantleSeerEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player reveals the top card of their library, loses life equal to that card's mana value, then puts it into their hand";
    }

    private DuskmantleSeerEffect(DuskmantleSeerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DuskmantleSeerEffect copy() {
        return new DuskmantleSeerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Card card;
            Player player = game.getPlayer(playerId);
            if (player == null || (card = player.getLibrary().getFromTop(game)) == null) continue;
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            player.loseLife(card.getManaValue(), game, source, false);
            player.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

