/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DwarvenArmorerEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    public DwarvenArmorerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put a +0/+1 counter or a +1/+0 counter on target creature.";
    }

    private DwarvenArmorerEffect(DwarvenArmorerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DwarvenArmorerEffect copy() {
        return new DwarvenArmorerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose type of counter to add");
            choice.setChoices(choices);
            if (controller.choose(this.outcome, (Choice)choice, game)) {
                Counter counter = choice.getChoice().equals("+0/+1") ? CounterType.P0P1.createInstance() : CounterType.P1P0.createInstance();
                AddCountersTargetEffect effect = new AddCountersTargetEffect(counter);
                effect.setTargetPointer((TargetPointer)new FixedTarget(this.getTargetPointer().getFirst(game, source), game));
                return effect.apply(game, source);
            }
        }
        return false;
    }

    static {
        choices.add("+0/+1");
        choices.add("+1/+0");
    }
}

