/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DwarvenDrillerEffect
extends OneShotEffect {
    DwarvenDrillerEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy target land unless its controller has {this} deal 2 damage to them";
    }

    private DwarvenDrillerEffect(DwarvenDrillerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DwarvenDrillerEffect copy() {
        return new DwarvenDrillerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            String message = "Have Dwarven Driller do 2 damage to you?";
            if (player.chooseUse(Outcome.Damage, message, source, game)) {
                player.damage(2, source.getSourceId(), source, game);
            } else {
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

